// Various Misc utils
#include <xc.h>
#include "util.h"

void delay(uint32_t t){
  uint32_t n;
  t=t*6000;                 //~1ms, may change depending on optimisation level, try 2400 for L0, 6k for L1
  for (n=0; n<t;++n){Nop();}
}

void delayUs(uint32_t t){
  uint32_t n;
  t=t*1;                 //6000 ~ 1ms
  for (n=0; n<t;++n){Nop();}
}

void errorflash(uint32_t n){
    uint32_t i;
    while(1){
        for(i=0;i<n;i++){
            LEDSet(0);
            delay(200);
            LEDSet(1);
            delay(200);
        }
        LEDSet(0);
        delay(500);
    }
}

void sleep(uint32_t t){
    SYSKEY = 0x0;
    SYSKEY = 0xAA996655;                    //unlock
    SYSKEY = 0x556699AA;
    //OSCCONbits.SLPEN=0;                     //enable idle
    OSCCONbits.SLPEN=1;                     //enable sleep
    SYSKEY = 0x0;                           //lock
    while(t){
        RCONCLR=0xDF;                       //clear all reset reason flags
        __builtin_disable_interrupts();
        SYSKEY = 0x0;
        SYSKEY = 0xAA996655;
        SYSKEY = 0x556699AA;
        RNMICONbits.WDTS=0;                 //clear sleep WDT flag
        SYSKEY = 0x0;
        WDTCONbits.WDTCLRKEY=0x5743;        //magic sequence to reset WDT
        WDTCONbits.ON=1;                    //enable
        //RCON;                               //dummy read
        asm volatile( "wait" );             //sleep/idle as per SLPEN
        Nop();
        WDTCONbits.ON=0;                    //disable
        t--;
    }
}
